unit MainUnit;

//  
//       
//  TValueListEditor.    
//   TStringGrid,    
//     .   
// ( ItemProps)     ( , 
//   ,    ),  
//   EditStyle.       
//  ( EditMask).

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, ValEdit, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    CBoxEditStyle: TComboBox;
    STextCol: TStaticText;
    STextRow: TStaticText;
    STextCell: TStaticText;
    STextKey: TStaticText;
    STextVal: TStaticText;
    CBoxEditMask: TComboBox;
    ValueListEditor1: TValueListEditor;
    LabelTitle: TLabel;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Shape1: TShape;
    Panel2: TPanel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Panel3: TPanel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    OpenDialog1: TOpenDialog;
    procedure FormShow(Sender: TObject);
    procedure CBoxEditStyleChange(Sender: TObject);
    procedure ValueListEditor1EditButtonClick(Sender: TObject);
    procedure ValueListEditor1Click(Sender: TObject);
    procedure ValueListEditor1DblClick(Sender: TObject);
    procedure CBoxEditMaskChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

//   
var LastInd : integer;

procedure TForm1.FormShow(Sender: TObject);
var Ind  : integer;
    WKey : string;
begin
 Ind := 0;
 //  
 ValueListEditor1.ItemProps[Ind].EditStyle := esSimple;
 ValueListEditor1.ItemProps[Ind].EditMask:='';
 WKey := ValueListEditor1.Keys[Ind+1];
 ValueListEditor1.Values[WKey] := ' ';
 //    - 
 Ind := Ind + 1;
 ValueListEditor1.ItemProps[Ind].EditStyle := esSimple;
 ValueListEditor1.ItemProps[Ind].EditMask:='00/00/0000';
 WKey := ValueListEditor1.Keys[Ind+1];
 ValueListEditor1.Values[WKey] := '01/01/2010';
 //    - 
 Ind := Ind + 1;
 ValueListEditor1.ItemProps[Ind].EditStyle := esSimple;
 ValueListEditor1.ItemProps[Ind].EditMask:='(000)_000_00_00';
 //   ComboBox
 Ind := Ind + 1;
 // ValueListEditor1.DropDownRows := 4;
 ValueListEditor1.ItemProps[Ind].EditStyle:=esPickList;
 ValueListEditor1.ItemProps[Ind].PickList.Add('');
 ValueListEditor1.ItemProps[Ind].PickList.Add('');
 ValueListEditor1.ItemProps[Ind].PickList.Add('');
 ValueListEditor1.ItemProps[Ind].PickList.Add('');
 ValueListEditor1.ItemProps[Ind].PickList.Add('');
 ValueListEditor1.ItemProps[Ind].PickList.Add('');
 WKey := ValueListEditor1.Keys[Ind+1];
 ValueListEditor1.Values[WKey] := '[None]';
 //    
 Ind := Ind + 1;
 ValueListEditor1.ItemProps[Ind].EditStyle := esEllipsis;
 WKey := ValueListEditor1.Keys[Ind+1];
 ValueListEditor1.Values[WKey] := '[None]';
 //  
 Ind  := Ind + 1;
 LastInd := Ind;
 ValueListEditor1.ItemProps[Ind].EditStyle := esSimple;
 ValueListEditor1.ItemProps[Ind].EditMask:='';
end;

//     () 
procedure TForm1.CBoxEditMaskChange(Sender: TObject);
begin
  case CBoxEditMask.ItemIndex of
  //  
  0 :  ValueListEditor1.ItemProps[LastInd].EditMask := '';
  //    CBoxEditMask
  else ValueListEditor1.ItemProps[LastInd].EditMask:=CBoxEditMask.Text;
  end;
end;

procedure TForm1.CBoxEditStyleChange(Sender: TObject);
begin
  case CBoxEditStyle.ItemIndex of
  //   
  0 : ValueListEditor1.ItemProps[LastInd].EditStyle := esSimple;
  //    EditButtonClick
  1 : ValueListEditor1.ItemProps[LastInd].EditStyle := esEllipsis;
  //   
  2 : begin
        ValueListEditor1.ItemProps[LastInd].EditStyle :=  esPickList;
        //  
        ValueListEditor1.ItemProps[LastInd].PickList.Clear;
        //    
        ValueListEditor1.ItemProps[LastInd].PickList.Add(' 1');
        ValueListEditor1.ItemProps[LastInd].PickList.Add(' 2');
      end;
  end;
end;

procedure TForm1.ValueListEditor1EditButtonClick(Sender: TObject);
var WKey, ShortFileName : string;
begin
  if OpenDialog1.Execute
  then begin
     ShortFileName := ExtractFileName(OpenDialog1.FileName);
     WKey := ValueListEditor1.Keys[LastInd + 1];
     ValueListEditor1.Values[WKey] := ShortFileName;
  end;
end;

//   ValueListEditor   StringGrid
procedure TForm1.ValueListEditor1Click(Sender: TObject);
var WCol, WRow : integer;
begin
  WCol := ValueListEditor1.Col;
  WRow := ValueListEditor1.Row;
  STextCol.Caption := IntToStr(WCol);
  STextRow.Caption := IntToStr(WRow);
  STextCell.Caption := ValueListEditor1.Cells[WCol,WRow];
end;

//   ValueListEditor   
procedure TForm1.ValueListEditor1DblClick(Sender: TObject);
var RInd : integer;
    Key : string;
begin
   RInd := ValueListEditor1.Row;
   Key := ValueListEditor1.Keys[RInd];
   STextKey.Caption := Key;
   STextVal.Caption := ValueListEditor1.Values[Key];
end;



end.
